/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.ospf.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.OSPFAuthType;
import com.cisco.pt.ipc.enums.OSPFDefaultInfoOrig;
import com.cisco.pt.ipc.enums.OSPFLogChanges;
import com.cisco.pt.ipc.sim.process.ospf.OSPFArea;
import com.cisco.pt.ipc.sim.process.ospf.OSPFAreaNetwork;
import com.cisco.pt.ipc.sim.process.ospf.OSPFProcess;
import com.cisco.pt.ipc.sim.process.routing.impl.RoutingProtocolImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFProcessImpl
extends RoutingProtocolImpl
implements OSPFProcess {
    public OSPFProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public int getProcessId() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getProcessId");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getProcessId");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public IPAddress getRouterId() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getRouterId");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public int getAreaCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getAreaCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public OSPFArea getAreaAt(int index) {
        return this.getFactory().getAreaAt(this, index);
    }

    @Override
    public OSPFArea getArea(IPAddress ipAddressArea) {
        return this.getFactory().getArea(this, ipAddressArea);
    }

    @Override
    public void removeArea(IPAddress ipAddressArea) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeArea");
        newCall.addIPAddressParameter(ipAddressArea);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean setAreaAuthentication(IPAddress ipAddressArea, OSPFAuthType type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setAreaAuthentication");
        newCall.addIPAddressParameter(ipAddressArea);
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.setAreaAuthentication");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public int getAreaAuthenticationCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaAuthenticationCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getAreaAuthenticationCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public Pair<Integer, IPAddress> getAreaAuthenticationAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaAuthenticationAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<Integer, IPAddress> answer = new Pair<Integer, IPAddress>((Integer)rawPair.getFirst(), (IPAddress)rawPair.getSecond());
        return answer;
    }

    @Override
    public OSPFAuthType getAreaAuthentication(IPAddress ipAddressArea) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaAuthentication");
        newCall.addIPAddressParameter(ipAddressArea);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getAreaAuthentication");
        }
        return OSPFAuthType.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public void setDefaultInfoOrig(OSPFDefaultInfoOrig type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultInfoOrig");
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public OSPFDefaultInfoOrig getDefaultInfoOrig() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDefaultInfoOrig");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getDefaultInfoOrig");
        }
        return OSPFDefaultInfoOrig.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public void setLogAdjacencyChanges(OSPFLogChanges type) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setLogAdjacencyChanges");
        newCall.addIntParameter(type.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public OSPFLogChanges getLogAdjacencyChanges() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getLogAdjacencyChanges");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getLogAdjacencyChanges");
        }
        return OSPFLogChanges.fromIntValue(returnMessage.getIntValue());
    }

    @Override
    public void addConfiguredNetwork(IPAddress ipAddressArea, IPAddress ipAddress, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addConfiguredNetwork");
        newCall.addIPAddressParameter(ipAddressArea);
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void removeConfigureNetwork(IPAddress ipAddressArea, IPAddress ipAddress, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeConfigureNetwork");
        newCall.addIPAddressParameter(ipAddressArea);
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getConfNetworkCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfNetworkCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getConfNetworkCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public OSPFAreaNetwork getConfNetworkAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getConfNetworkAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (OSPFAreaNetwork)returnMessage.getObjectValue();
    }

    @Override
    public IPAddress getAreaId(IPAddress ipAddress, IPAddress mask) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getAreaId");
        newCall.addIPAddressParameter(ipAddress);
        newCall.addIPAddressParameter(mask);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }

    @Override
    public void setDefaultPassiveInt(boolean b) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setDefaultPassiveInt");
        newCall.addBoolParameter(b);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean getDefaultPassiveInt() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getDefaultPassiveInt");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: OSPFProcessImpl.getDefaultPassiveInt");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setPassiveInt(String portname, boolean bPassive) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPassiveInt");
        newCall.addStringParameter(portname);
        newCall.addBoolParameter(bPassive);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void generateOspfRoutes(IPAddress ipAddressAreaID) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("generateOspfRoutes");
        newCall.addIPAddressParameter(ipAddressAreaID);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }
}

